def test2():
    y = Y.r(os.path.join(os.path.dirname(__file__), 'input2.txt'))
    a, b = y.p('A', 'C')
    assert len(b) == 4
    assert b[0] == 'A' and b[1] == 'D' and b[2] == 'B' and b[-1] == 'C'
    assert a == 1.5

import importlib.util
import sys
import os

def test3():
    y = Y.r(os.path.join(os.path.dirname(__file__), 'input3.txt'))
    # Partition 1
    x1, y1 = y.p('A', 'D')
    assert len(y1) == 2
    assert y1[0] == 'A' and y1[-1] == 'D'
    assert x1 >= 1.41 and x1 < 1.42
    # Partition 2
    x2, y2 = y.p('E', 'G')
    assert len(y2) == 3
    assert y2[0] == 'E' and y2[1] == 'F' and y2[-1] == 'G'
    assert x2 >= 2.41 and x2 < 2.42
    # Between partitions (should not exist)
    x3, y3 = y.p('A', 'E')
    assert y3 == []
    assert x3 == float('inf')

spec = importlib.util.spec_from_file_location("App", os.path.join(os.path.dirname(__file__), "App.py"))
if spec and spec.loader:
    App = importlib.util.module_from_spec(spec)
    sys.modules["App"] = App
    spec.loader.exec_module(App)
    Y = App.Y
else:
    raise ImportError("Could not import App module.")

def test1():
    # Use the input1 file
    import os
    y = Y.r(os.path.join(os.path.dirname(__file__), 'input1.txt'))
    u, v = y.p('A', 'H')
    assert len(v) <= 5 and len(v) >= 4
    assert v[0] == 'A' and v[1] == 'B' and v[-1] == 'H'
    assert u == 4.
